/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetLongestValidPathCommand
extends VerificationCommand {
    private static String m_arg1 = "-getlongestvaliddir";
    private static String m_arg2 = "-w";

    public GetLongestValidPathCommand(String nodeName, String path, boolean isWritable) {
        super(nodeName, null, null);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String[] args = null;
        String pathToProcess = null;
        pathToProcess = !nativeSystem.isUnixSystem() ? "\"" + path + "\"" : path;
        args = isWritable ? new String[]{m_arg1, m_arg2, pathToProcess} : new String[]{m_arg1, pathToProcess};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetLongestValidPathCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetLongestValidPathCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting exectask version failed");
            result.addErrorInfo("getting exectask version failed");
            result.setStatus(2);
            return false;
        }
        Trace.out((String)"super.execute() was succcessful for GetLongestValidPathCommand...");
        String[] resultString = this.getCommandResult().getResultString();
        String exectaskFmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        if (!VerificationUtil.fetchExecResult(exectaskFmtdStr)) {
            String trcTxt = "Exectask result shows failure for -getlongestvaliddir...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting longest valid path failed");
            result.addErrorInfo("getting longest valid path failed");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationStatus(exectaskFmtdStr)) {
            String trcTxt = "Exectask result shows verification failure for -getlongestvaliddir...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting longest valid path failed");
            result.addErrorInfo("getting longest valid path failed");
            result.setStatus(3);
            return false;
        }
        String longestValidPath = VerificationUtil.fetchVerificationValue(exectaskFmtdStr);
        Trace.out((String)"after calling fetchVerificationValue() ");
        Trace.out((String)("The  longest valid path on node '" + this.getNodeName() + "' is '" + longestValidPath + "'"));
        result.addTraceInfo("The longest valid path on node '" + this.getNodeName() + "' is '" + longestValidPath + "'");
        result.addResultInfo(longestValidPath);
        result.setStatus(1);
        return true;
    }
}

